*** COS 2020 08, last update 2022 11  
           
program define dq_fil_mrg, rclass  
syntax , [filetype(string)]	$syntax_datasource_files  $syntax_variablelists $syntax_debugging  
local indent=`indent'+5  
local adoname "dq_fil_mrg"  
local text_i "di as text _n "  					  
local reportstop=0								  
local filenumber=0								  
tokenize `targetfiles'							  
while "`1'"~="" {  
	local file="`1'"  
	local filenumber=`filenumber'+1	  
		         
	if `filenumber' == 1 {  
		use "`rd'\`file'_c_leaned.dta", clear										  
	}         
	if `filenumber' > 1  {  					  
		capture merge 1:1 `idvars' using "`rd'\`file'_c_leaned.dta", force update  
		local mergesuccess=_rc  
		if `mergesuccess'==0 {																					  
			        
			forvalues n=1/5 {  
				qui count if _merge==`n'  
				local merge_`filenumber'_`n'=r(N)  
			}       
			        
			local discrepant_`filenumber'	=`merge_`filenumber'_1'+`merge_`filenumber'_2'  
			local nomatch_`filenumber'		=`merge_`filenumber'_3'+`merge_`filenumber'_4'+`merge_`filenumber'_5'  
			if `discrepant_`filenumber''>0 & `nomatch_`filenumber''>0 {  
				*** DQ_quality_decision: 	DQ_INT_13  
				`text_i' "Data records in different data sets do not match exactly. Affected dataset: `file'"  
				dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Warning_1") colcontent2("Merge file: `file'") ///  
												colcontent3($DQ_INT_warn_13 `discrepant_`filenumber'' $DQ_INT_note1_13 `merge_`filenumber'_1' $DQ_INT_note2_13 `merge_`filenumber'_2')  indent(`indent')	  
			}       
			        
			if `nomatch_`filenumber''==0 {  
				*** DQ_quality_decision: 	DQ_INT_14  
				`text_i' "Different data sets do not share a single common data record. Affected dataset: `file'"  
				dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Critical_1") colcontent2("Merge file: `file'") ///  
												colcontent3($DQ_INT_critical_14)  indent(`indent')	  
				local reportstop=1  
			}       
						     
			*if r(N)>0 dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Note_1") colcontent2("Merge file `file'") colcontent3($nonuniquematch_warn_3 `r(N)')  indent(`indent')	  
			*if r(N)>0 dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) colcontent1("$Note_1") colcontent2("Merge file `file'") colcontent3($nonuniquematch_warn_4 `r(N)')  indent(`indent')	  
			        
			        
			rename _merge _merge_`filenumber'																	  
			lab var _merge_`filenumber' "Merge with `file'"  
		}        
		         
		if `mergesuccess'>0 {																					  
		         
			*** DQ_quality_decision: 	DQ_INT_15  
			dq_out_add ,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) ///  
											colcontent1("$Critical_1") colcontent2("Merge file `file'") colcontent3($DQ_INT_critical_15)  indent(`indent')	  
			local reportstop=1  
		}        
			        
	}         
		         
	macro shift																									  
}          
return local reportstop=`reportstop'  
end        
